package getp;
// Java ̍ŏɍꂽGUIawtŁATCPڑT[oM摜Canvasɕ`悷JԂ̍i
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.ImageIO;
// Ql:https://bytes.com/topic/java/answers/16573-imageio-read-socket-stream
import javax.imageio.stream.ImageInputStream;
import java.net.*;
import java.nio.ByteBuffer;

public class PaintImage extends Frame implements ActionListener, Runnable {
    BufferedImage bufferedImage = new BufferedImage(800,800,BufferedImage.TYPE_INT_RGB);
    int width, height;
    Panel panel = new Panel();
    Label labelIP= new Label("IP Address:");
    TextField textFieldIP= new TextField("192.168.71.8");
    Label labelPort= new Label("@@@Port No:");
    TextField textFieldPort= new TextField("3000");
    Button btnCtrl= new Button("START");
    Label labelMsg= new Label("It is an application that receives and displays images.");
    ScrollPane scrPane = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS); //ɃXN[o[\
    Thread thread = null;
    Canvas canvas = new Canvas(){
        public void paint(Graphics graphics) {
            graphics.drawImage(bufferedImage, 0, 0, null);//`揈
        }
    };
    public static void main(String [] args)  throws Exception  {
        new PaintImage();
    }
    PaintImage() throws Exception {
        super("PaintImage");
        setLayout(new BorderLayout());
        panel.add(labelIP);
        panel.add(textFieldIP);
        panel.add(labelPort);
        panel.add(textFieldPort);
        panel.add(btnCtrl);
        add(panel,BorderLayout.NORTH);
        scrPane.add(canvas);
        add(scrPane,BorderLayout.CENTER);
        add(labelMsg,BorderLayout.SOUTH);
        loadTxt();
        setSize(800, 800); setVisible(true);
        btnCtrl.addActionListener(this);
        this.addWindowListener( new WindowAdapter(){
           public void windowClosing(WindowEvent e){// {^
                thread = null;
                saveTxt();
                PaintImage.this.dispose();//jāAIB
            }
        });
    }

    void saveTxt(){
        try {
            FileOutputStream os=new FileOutputStream("getpaint.txt");
            String s="IP:" + textFieldIP.getText() + "\r\n";
            s += "PORT:" + textFieldPort.getText() + "\r\n";
            os.write( s.getBytes() );
            os.close();
        } catch(Exception e){
        }
    }

    static String getValue(String s,String key){
        int i1 = s.indexOf(key);
        int i2 = s.indexOf("\r\n", i1);
        if(i1 == -1 || i2 == -1) return "";
        return s.substring(i1+key.length(), i2);
    }

    void loadTxt(){
        try {
            File file = new File("getpaint.txt");
            FileInputStream is=new FileInputStream(file);
            byte []buf = new byte[(int) file.length()];
            is.read(buf);
            String s = new String(buf);
            textFieldIP.setText(getValue(s, "IP:"));
            textFieldPort.setText(getValue(s, "PORT:"));
        } catch(Exception e){
        }
    }


    public void run(){
        while( thread != null ){
            try {
                Thread.sleep(1000);
                labelMsg.setText("Waiting for connection");
                getImage();
                canvas.repaint();
                labelMsg.setText("OK("+ width + "," + height +")");
            } catch(Exception err){
                String msg = err.getMessage();
                System.out.println(msg);
                labelMsg.setText(msg);
                thread = null;
                btnCtrl.setLabel("START");
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent e){
        if(e.getSource() == btnCtrl){
            if( thread != null){
                thread = null;
                btnCtrl.setLabel("START");
            } else {
                labelMsg.setText("started !");
                thread = new Thread(this);
                thread.start();// run̎s
                btnCtrl.setLabel("STOP");
            }
        }
	}

    public void getImage() throws Exception {
           String ip= textFieldIP.getText();
           int port = Integer.parseInt(textFieldPort.getText());
           System.out.println(ip + ":" + port);
           Socket socket = new Socket(ip,port);
           
           ImageInputStream inputStream = ImageIO.createImageInputStream(socket.getInputStream());

           bufferedImage = ImageIO.read(inputStream);
           width = bufferedImage.getWidth(this);
           height = bufferedImage.getHeight(this);
           canvas.setSize(width,height);
           System.out.println("bufferedImage" + bufferedImage.toString());
    }

    public void getImage_ok(){
        try{
            
            Socket socket = new Socket("127.0.0.1",3000);
          
            InputStream inputStream = socket.getInputStream();

            bufferedImage = ImageIO.read(inputStream);

            System.out.println("bufferedImage" + bufferedImage.toString());
        }
        catch(Exception e){
        }    
    }

    public void getImage_2(){
        try{
            byte []buf = new byte[1000000];
            int  count = 0;
            Socket socket = new Socket("127.0.0.1",3000);
            InputStream inputStream = socket.getInputStream();
            for(;;){
               int c = inputStream.read();
               if( c == -1 ) break;
               buf[count++] = (byte) c;
           }
           System.out.println("MTCY:" + count);

           System.out.println("bufferedImage" + bufferedImage.toString());
        }
        catch(Exception e){
        }    
    }

    public void getImage_1(){
        try{
           InputStream inputStream = new FileInputStream(new File("cat.jpg"));
           bufferedImage = ImageIO.read(inputStream);
           System.out.println("bufferedImage" + bufferedImage.toString());
        }
        catch(Exception e){
        }    
    }
}